<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Post;

trait TraitHashtagPostSetters
{
    use TraitHashtagPostProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setHashtagId(string $hashtagId)
    {
        $this -> hashtagId = $hashtagId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPostId(string $postId)
    {
        $this -> postId = $postId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPostOwnerUserId(string $postOwnerUserId)
    {
        $this -> postOwnerUserId = $postOwnerUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
